/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.validacion.esquema;

import ec.gob.sri.dimm.api.modelo.validacion.MensajeValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.validacion.esquema.ValidacionXSDErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ValidacionEsquema {
    public static ResultadoValidacion validarEsquema(InputStream xmlFile, InputStream xsd) {
        ResultadoValidacion resultado = new ResultadoValidacion();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser parser = null;
        spf.setNamespaceAware(false);
        InputSource xmlSource = new InputSource(xmlFile);
        InputSource xsdSource = new InputSource(xsd);
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            spf.setSchema(sf.newSchema(new SAXSource(xsdSource)));
            parser = spf.newSAXParser();
            ValidacionXSDErrorHandler handler = new ValidacionXSDErrorHandler();
            parser.parse(xmlSource, (DefaultHandler)handler);
            if (handler.getErrors().length() > 0) {
                String[] stringArray = handler.getErrors().split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String error = stringArray[n2];
                    resultado.agregarMensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, error);
                    ++n2;
                }
            }
        }
        catch (SAXException sAXException) {
            resultado.agregarMensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "Error validando el XSD: El XML esta mal formado");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            resultado.agregarMensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "Error validando el XSD: El XML esta mal formado");
        }
        catch (IOException iOException) {
            resultado.agregarMensajeValidacion(MensajeValidacion.NivelMensaje.ERROR, "Error validando el XSD: El XML esta mal formado");
        }
        return resultado.completarValidacionVariosMensajes();
    }

    public abstract InputStream obtenerEsquema();
}

